/*
 * Created on Sep 18, 2003
 */
package Interface;
import javax.mail.*;
import javax.mail.internet.*;
import java.util.*;
import java.io.*;

/**
 
 * This class is being used to send email 
 * 
 */
public class Mail {

	/**
	 * This is the constructor for Mail.java
	 */
	public Mail() {

	}

	/**
	 * This method is being used send email
	 * @param recipients array of recipients email addresses
	 * @param subject subject of the email
	 * @param message email message
	 * @throws MessagingException void
	 */
	public static void postMail(
		String recipients[],
		String subject,
		String message)
		throws MessagingException {
		boolean debug = false;
		String from = "";
		String smtphost = "";
		try {

			//read configuration file
			Properties p = new Properties();
			p.load(new FileInputStream("configuration.txt"));
			smtphost = p.getProperty("SMTPHOST");
			from = p.getProperty("SENDEMAIL");

		} catch (Exception e) {
			System.out.println(
				"Exception while reading configuration.txt: " + e.toString());
		}
		//Set the host smtp address
		Properties props = new Properties();
		props.put("mail.smtp.host", smtphost);

		// create some properties and get the default Session
		Session session = Session.getDefaultInstance(props, null);
		session.setDebug(debug);

		// create a message
		Message msg = new MimeMessage(session);

		// set the from and to address
		InternetAddress addressFrom = new InternetAddress(from);
		msg.setFrom(addressFrom);

		InternetAddress[] addressTo = new InternetAddress[recipients.length];
		for (int i = 0; i < recipients.length; i++) {
			addressTo[i] = new InternetAddress(recipients[i]);
		}
		msg.setRecipients(Message.RecipientType.TO, addressTo);

		// Optional : You can also set your custom headers in the Email if you Want
		msg.addHeader("MyHeaderName", "myHeaderValue");

		// Setting the Subject and Content Type
		msg.setSubject(subject);
		msg.setContent(message, "text/plain");
		Transport.send(msg);

	}
}
